//
//  ManojPdfViewController.m
//  Radaeepdf Demo App
//
//  Created by Manoj Aher on 8/4/15.
//  Copyright (c) 2015 manojaher. All rights reserved.
//

#import "ManojPdfViewer.h"
#import "PDFThumbView.h"
#import "ManojPDFView.h"

@interface ManojPdfViewer ()<PDFViewDelegate, PDFThumbViewDelegate>

@end

@implementation ManojPdfViewer

@synthesize pdfViewer = _pdfViewer;

NSUserDefaults *userDefaults;
int g_render_quality = 1;

#pragma mark - init method
- (instancetype) initWithDocumentPath:(NSString*)documentPath
{
    self = [super initWithNibName:@"ManojPdfViewer" bundle:nil];
    if(self)
    {
    }
    return self;
}

#pragma mark - lifecycle methods
- (void)viewDidLoad {
    [super viewDidLoad];
    [self loadSettingsWithDefaults];
    [self setupPdfView];
}

#pragma mark - PDFViewDelegate methods
- (void)OnPageChanged :(int)pageno
{
    [m_Thumbview vGoto:pageno];
}

- (void)OnAnnotClicked:(PDFPage *)page :(PDFAnnot *)annot :(float)x :(float)y
{
    NSLog(@"I m here and the uri is %@", [annot getURI]);
}

- (void)OnLongPressed:(float)x :(float)y
{}
- (void)OnSingleTapped:(float)x :(float)y
{}
- (void)OnDoubleTapped:(float)x :(float)y
{}
- (void)OnFound:(bool)found
{}
- (void)OnSelStart:(float)x :(float)y
{}
- (void)OnSelEnd:(float)x1 :(float)y1 :(float)x2 :(float)y2
{}

//notified when annotation status end.
- (void)OnAnnotEnd
{}
//this mehod fired only when vAnnotPerform method invoked.
- (void)OnAnnotGoto:(int)pageno
{}
//this mehod fired only when vAnnotPerform method invoked.
- (void)OnAnnotPopup:(PDFAnnot *)annot :(NSString *)subj :(NSString *)text
{}
//this mehod fired only when vAnnotPerform method invoked.
- (void)OnAnnotOpenURL:(NSString *)url
{}
//this mehod fired only when vAnnotPerform method invoked.
- (void)OnAnnotMovie:(NSString *)fileName
{}
//this mehod fired only when vAnnotPerform method invoked.
- (void)OnAnnotSound:(NSString *)fileName
{}


#pragma mark - PDFThumbViewDelegate method
- (void)OnPageClicked :(int) pageno
{
    [pdfViewer vGoto:pageno];
}

#pragma mark - Private methods
- (void)loadSettingsWithDefaults
{
    renderQuality = mode_best;
    g_def_view = 3;// for horizontal view
}

- (void)setupPdfView
{
    [self openPDF];
    [self setupThumbnailView];
}

- (void)openPDF
{
    NSString* pdfFullPath = [[NSBundle mainBundle] pathForResource:@"test"ofType:@"pdf"];
    
    [self PDFClose];
    
    PDF_ERR err = 0;
    pdfDoc = [[PDFDoc alloc] init];
    err = [pdfDoc open:pdfFullPath :@""];
    
    pdfViewer = [[ManojPDFView alloc] initWithFrame:CGRectMake(0, 0, self.pdfViewer.frame.size.width, self.pdfViewer.frame.size.height)];
    [pdfViewer vOpen :pdfDoc :self];
    [pdfViewer setAutoresizingMask:UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleHeight];
    [self.pdfViewer addSubview:pdfViewer];
}

- (void)setupThumbnailView
{
    m_Thumbview = [[PDFThumbView alloc] initWithFrame:CGRectMake(0, 0, self.thumbnailView.frame.size.width, self.thumbnailView.frame.size.height)];
    [m_Thumbview vOpen :pdfDoc :(id<PDFThumbViewDelegate>)self];
    m_Thumbview.showsHorizontalScrollIndicator = false;
    [self.thumbnailView addSubview:m_Thumbview];
}

- (void)PDFClose
{
    if( pdfViewer != nil ) {
        [pdfViewer vClose];
        [pdfViewer removeFromSuperview];
        pdfViewer = NULL;
    }
    pdfDoc = NULL;
}

- (void)didRotateFromInterfaceOrientation:(UIInterfaceOrientation)fromInterfaceOrientation
{
    [self resizePDFAndThumbnailView];
}

- (void)resizePDFAndThumbnailView
{
    [self resizePDFView];
    [self resizeThumnailView];
    [pdfViewer resetZoomLevel];
}

- (void)resizePDFView
{
    //Resize PDF View
    //    [UIView animateWithDuration:0.3 animations:^{
    
    [self.pdfViewer setFrame:CGRectMake(self.pdfViewer.frame.origin.x, self.pdfViewer.frame.origin.y, self.pdfViewer.frame.size.width, self.pdfViewer.frame.size.height)];
    
    CGRect rect = self.pdfViewer.frame;
    rect.origin = CGPointZero;
    if ([self isPortrait])
    {
        if (rect.size.height < rect.size.width)
        {
            float height = rect.size.height;
            rect.size.height = rect.size.width;
            rect.size.width = height;
        }
    }
    else
    {
        if (rect.size.height > rect.size.width)
        {
            float height = rect.size.height;
            rect.size.height = rect.size.width;
            rect.size.width = height;
        }
    }
    [pdfViewer setFrame:rect];
    [pdfViewer sizeThatFits:rect.size];
    
    //    }];
    
}

- (void)resizeThumnailView
{
    //Resize thumbnail View
    if(m_Thumbview)
    {
        CGRect boundsc = self.thumbnailView.frame;
        [m_Thumbview setFrame:CGRectMake(0, 0, boundsc.size.width, boundsc.size.height)];
        [m_Thumbview sizeThatFits:boundsc.size];
        [m_Thumbview refresh];
    }
}

- (BOOL)isPortrait
{
    return ([[UIApplication sharedApplication] statusBarOrientation] == UIInterfaceOrientationPortrait ||
            [[UIApplication sharedApplication] statusBarOrientation] == UIInterfaceOrientationPortraitUpsideDown);
}

- (void)hidethumbNail
{
    
    [self.thumbnailView setFrame:CGRectZero];
    [self resizeThumnailView];
    [self resizePDFView];
}

- (IBAction)hideThumbnail:(id)sender
{
    [self hidethumbNail];
}


@end
